/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.BabyEnderDragonConfig;
import com.tristankechlo.livingthings.entity.ai.CustomSitWhenOrderedToSitGoal;
import com.tristankechlo.livingthings.entity.projectile.CustomDragonFireball;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class BabyEnderDragonEntity
extends TamableAnimal
implements NeutralMob,
RangedAttackMob,
FlyingAnimal,
ILexiconEntry {
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.m_135353_(BabyEnderDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BabyEnderDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;

    public BabyEnderDragonEntity(EntityType<? extends BabyEnderDragonEntity> entity, Level level) {
        super(entity, level);
        this.m_7105_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CustomSitWhenOrderedToSitGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredients.BABY_ENDERDRAGON_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.1, 120, 240, (float)BabyEnderDragonConfig.followRange()));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.3, 10.0f, 3.0f, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, true, arg_0 -> ((BabyEnderDragonEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
    }

    protected void m_8024_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_21344_.m_26571_() && this.m_21827_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        }
        super.m_8024_();
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.m_7008_(true);
        navigation.m_26440_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (stack.m_150930_(ModItems.LEXICON.get())) {
            return InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, hand, stack);
                this.m_5634_(item.m_41473_().m_38744_() / 2);
                this.m_146852_(GameEvent.f_223708_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (this.m_21830_((LivingEntity)player) && item instanceof DyeItem) {
                DyeColor dyecolor = ((DyeItem)item).m_41089_();
                if (dyecolor != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    this.m_142075_(player, hand, stack);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41619_() && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
        } else if (!this.m_21824_() && this.m_6898_(stack) && !this.m_21660_()) {
            this.m_142075_(player, hand, stack);
            if (this.f_19796_.m_188503_(5) == 0 && !this.m_9236_().m_5776_()) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.BABY_ENDERDRAGON_FOOD);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setCollarColor(DyeColor.m_41053_((int)nbt.m_128451_("CollarColor")));
        this.m_147285_(this.m_9236_(), nbt);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128376_("CollarColor", (short)this.getCollarColor().m_41060_());
        this.m_21678_(nbt);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, BabyEnderDragonConfig.health()).m_22268_(Attributes.f_22279_, BabyEnderDragonConfig.movementSpeed()).m_22268_(Attributes.f_22280_, BabyEnderDragonConfig.flyingSpeed()).m_22268_(Attributes.f_22277_, BabyEnderDragonConfig.followRange());
    }

    public static boolean checkBabyEnderDragonSpawnRules(EntityType<BabyEnderDragonEntity> entityType, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.BABY_ENDER_DRAGON_SPAWNABLE_ON);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor dyeColor) {
        this.f_19804_.m_135381_(COLLAR_COLOR, (Object)dyeColor.m_41060_());
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)time);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        BabyEnderDragonEntity child = (BabyEnderDragonEntity)ModEntityTypes.BABY_ENDER_DRAGON.get().m_20615_((Level)world);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            child.m_21816_(uuid);
            child.m_7105_(true);
        }
        return child;
    }

    public void m_6504_(LivingEntity entity, float distanceFactor) {
        boolean peaceful = this.m_9236_().m_46791_() == Difficulty.PEACEFUL;
        boolean ambientMode = GeneralConfig.get().ambientMode.get();
        if (peaceful || ambientMode || !BabyEnderDragonConfig.canAttack()) {
            return;
        }
        if (!this.m_6779_(entity)) {
            return;
        }
        Vec3 vec = this.m_20252_(1.0f);
        double d1 = this.m_20185_() - vec.f_82479_;
        double d2 = this.m_20227_(0.5);
        double d3 = this.m_20189_() - vec.f_82481_;
        double d4 = entity.m_20185_() - d1;
        double d5 = entity.m_20227_(0.5) - d2;
        double d6 = entity.m_20189_() - d3;
        CustomDragonFireball dragonfireball = new CustomDragonFireball(this.m_9236_(), (LivingEntity)this, d4, d5, d6);
        dragonfireball.m_7678_(d1, d2, d3, 0.0f, 0.0f);
        this.m_9236_().m_7967_((Entity)dragonfireball);
        if (!this.m_9236_().m_5776_() && !this.m_20067_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.BABY_ENDER_DRAGON_SHOOT.get(), SoundSource.HOSTILE, 2.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public int m_5792_() {
        return BabyEnderDragonConfig.maxSpawnedInChunk();
    }

    protected SoundEvent m_7515_() {
        return ModSounds.BABY_ENDER_DRAGON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return ModSounds.BABY_ENDER_DRAGON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.BABY_ENDER_DRAGON_DEATH.get();
    }

    public int m_8100_() {
        return 300;
    }

    protected void m_142043_() {
        this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.BABY_ENDER_DRAGON_FLAP.get(), SoundSource.AMBIENT, 2.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7640_() instanceof AreaEffectCloud) {
            return this == source.m_7639_();
        }
        return super.m_6469_(source, damage);
    }

    public boolean m_21670_(Level level) {
        return !this.m_21824_();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.BABY_ENDER_DRAGON;
    }
}

